/*
#include <iostream>

using namespace std;
*/

typedef long long ll;

int n;
ll mod = 1e9+7;

int abs(int x)
{
    return (x < 0) ? -x : x;
}

int pov(int x)
{
    return (x+3)%n + 1;
}

int dist(int a, int b)
{
    if(a > b) return n - (a - b - 1) - 2;
    return (b - a -1);
}

bool uIntervalu(int i, int l, int d)
{
    if(l < d) return l <= i && i <= d;
    else return !uIntervalu(i, (l == 1) ? n : l-1, d%n+1);
}

ll mem[501][501];

ll brNacina(int l, int d, int *a, int dub = 0)
{
    if(d - l + 1 == 4) return (a[l] + a[l+1] + a[l+2] + a[l+3])%2 == 1;
    if(mem[l][d] != -1) return mem[l][d];

    //for(int i = 0; i < dub; i++) cout << "\t";
    //cout << "Pozvan za " << l << " " << d << " " << endl;
    ll rez = 0;

    for(int i = l%n + 1; uIntervalu(i, l, d); i = pov(i))
    {
        for(int j = i%n + 1; uIntervalu(j, l, d); j = pov(j))
        {
            for(int k = j%n + 1; uIntervalu(k, l, d); k = pov(k))
            {
                if((a[i] + a[j] + a[k] + a[l]) % 2 == 1)
                {
                    //cout << "Validna trojka " << root << " " << i << " " << j << " " << k << endl;
                    ll a1 = 1, a2 = 1, a3 = 1, a4 = 1;
                    if(abs(l - i) != 1) a1 = brNacina(l%n + 1, i-1, a, dub+1);
                    if(abs(i - j) != 1) a2 = brNacina(i%n + 1, j-1, a, dub+1);
                    if(abs(j - k) != 1) a3 = brNacina(j%n + 1, k-1, a, dub+1);
                    if(k != d) a4 = brNacina(k%n + 1,  d, a, dub+1);
                    rez = (rez + (((((a1*a2)%mod)*a3)%mod)*a4)%mod) % mod;
                }
                //else cout << "Nije validna " << root << " " << i << " " << j << " " << k << endl;
            }
        }
    }
    //while(dub--) cout << "\t";
    //cout << "Ovako moze " << rez << endl;
    mem[l][d] = rez%mod;
    return rez%mod;
}

int Zvezda(int nn, int *a)
{
    n = nn;
    for(int i = 1; i <= n; i++)
        for(int j = 1; j <= n; j++)
            mem[i][j] = -1;
    if(n == 4) return (a[1] + a[2] + a[3] + a[4])%2 == 1;
    ll rez = 0;

    for(int i = 2; true; i = pov(i))
    {
        for(int j = i%n + 1; true; j = pov(j))
        {
            for(int k = j%n + 1; true; k = pov(k))
            {
                if((a[i] + a[j] + a[k] + a[1]) % 2 == 1)
                {
                    //cout << "\tValidna trojka " << root << " " << i << " " << j << " " << k << endl;
                    ll a1 = 1, a2 = 1, a3 = 1, a4 = 1;
                    if(abs(1 - i) != 1) a1 = brNacina(2, i-1, a);
                    if(abs(i - j) != 1) a2 = brNacina(i%n + 1, j-1, a);
                    if(abs(j - k) != 1) a3 = brNacina( j%n + 1, k-1, a);
                    if(k != n) a4 = brNacina(k%n + 1, n, a);

                    rez = (rez + (((((a1*a2)%mod)*a3)%mod)*a4)%mod) % mod;
                }
                //else cout << "\tNije validna " << root << " " << i << " " << j << " " << k << endl;
                if(pov(k) < k) break;
            }
            if(pov(j) < j) break;
        }
        if(pov(i) < i) break;
    }
    return rez%mod;
}

/*
int main()
{
    int n;
    cin >> n;
    int a[n];
    for(int i = 1; i <= n; i++) cin >> a[i];
    cout << Zvezda(n, a);
    return 0;
}
*/